   
;   Filename:	I2C_MONITOR
;   Date:	26/01/2020
;   Author:	J T Nestor
;   Files required: P18F4620.INC
;   Build using MPASMWIN using absolute mode.
;
;   Description:
;Monitors I2C clock and data lines, displaying each byte as a pair of ASCII chars.
;I2C clock on PORTC, 0, data on PORTC, 1.  Both bits are Schmitt trigger
;Ack or Nak is indicated by A or N, start by S, restart by R, stop by P, CR, LF
;Works at 100KHz, may work at 400 KHz but tight, depending on random interrupts.
;   
	processor 	18f4620
	include	<p18f4620.inc>
	list P=18F4620, r=dec, n=0, c=160
;
;   setup to use (the 4xPLL with) the 8 MHz internal oscillator	32 MIPS
;
; PIC18F4620 Configuration Bit Settings
	CONFIG  OSC = INTIO67, FCMEN = OFF, IESO = ON, PWRT = ON
	CONFIG  BOREN = OFF, BORV = 3, WDT = OFF, WDTPS = 32768
	CONFIG  CCP2MX = PORTC, PBADEN = OFF, LPT1OSC = OFF
	CONFIG  MCLRE = ON, STVREN = ON, LVP = OFF, XINST = OFF
	CONFIG  CP0 = OFF, CP1 = OFF, CP2 = OFF, CP3 = OFF
	CONFIG  CPB = OFF, CPD = OFF
	CONFIG  WRT0 = OFF, WRT1 = OFF, WRT2 = OFF, WRT3 = OFF
	CONFIG  WRTC = OFF, WRTB = OFF, WRTD = OFF
	CONFIG  EBTR0 = OFF, EBTR1 = OFF, EBTR2 = OFF, EBTR3 = OFF
	CONFIG  EBTRB = OFF
;
true	equ	1
false	equ	0
;
;Change the semicolons on the next two lines to run forever
stop256	equ true		;stop after 256 ack / naks
;stop256	equ false		;stop after 256 ack / naks
;
uartsp	equ	.68		;= 115,200 @ 32MHz
; 
CR	equ	0x0D
LF	equ	0x0A
SP	equ	0x20
i2cprt	equ	PORTC		;I/O = ST
i2ctris	equ	TRISC		;I/O = ST
i2cclk	equ	0
i2cdat	equ	1
;
nib	equ	0x7B		;data nibble
loopz	equ	0x7C		;counter
loopx	equ	0x7D		;2 nibbles in byte
loopy	equ	0x7E		;4 bits in nibble
;
reset0:	org	0x0000	
	goto	start		;around interrupt vextor
;
inthi:	org	0x08		;High interrupt vector
;print next char from buffer (INDF1)
	movf	INDF1,W		;get char and set Z flag
	BZ	inthi1		;don't print null
	movwf	TXREG,1		;print anything else, clears TXIF
	movf	POSTINC1,W,1	;both hi & lo
	bcf	FSR1H,3		;ensure buffer 000 to 7FF
	RETFIE FAST		;return leaving int enable true
;
inthi1:	bcf	PIE1,TXIE,1	;disable interrupt enable
	RETFIE FAST		;return leaving int enable false
;
intlo:	org	0x18		;Low interrupt vector
	RETFIE	FAST
;
start:
;set oscillator 
	movlw	0x0F		;bank 16
	movwf	BSR	  	;BSR points to top bank 0-7F GPR, 80-FF FSR
	movlw	0x70		;IRCF 2-0 111, SCS 1-0 00: 8MHz Internal Primary
	movwf	OSCCON,1   	;Set primary oscillator as system clock source
	clrf	OSCTUNE,1
	bsf	OSCTUNE,PLLEN,1	;enable PLL
;set serial port
	bcf	PIE1,TXIE,1		;disable interrupt enable
	clrf	BAUDCON,1
	bsf	BAUDCON,BRG16,1		;enable 16 bit baud divider
	clrf	RCSTA,1
	bsf	RCSTA,SPEN,1		;enable serial port	
	bsf	TRISC,6,1		;set RS232 IO bits
	bsf	TRISC,7,1
	clrf	SPBRGH,1
	movlw	uartsp			;115,200 @ 32 MHz
	movwf	SPBRG,1
	clrf	TXSTA,1
	bsf	TXSTA,BRGH,1		;Higb Baud Rate
	bcf	TXSTA,SYNC,1		;Asynchronous
	bsf	TXSTA,TXEN,1		;Transmitter enabled
	bcf	TXSTA,TX9,1		;8 bit data
;
	clrf	loopy,1			;delay 32 mS
lD01:	clrf	loopx,1
lD02:	nop
	decfsz	loopx,1
	goto	lD02
	decfsz	loopy,1
	goto	lD01
;
	clrf	STATUS,1
	bcf	RCON,IPEN,1		;Legacy interrupt mode
	bsf	INTCON,GIE,1		;Enable all interrupts
	bsf	INTCON,PEIE,1		;Enable Peripheral Interrupt 
;
	bsf	i2ctris,i2cclk,1	;i2c clk
	bsf	i2ctris,i2cdat,1	;i2c data
;
	clrf	FSR0L,1			;inbuffer pointer
	clrf	FSR0H,1			;inbuffer pointer
	clrf	FSR1L,1			;outbuffer pointer
	clrf	FSR1H,1			;outbuffer pointer
;
	movlw	"I"
	movwf	POSTINC0
	movlw	"2"
	movwf	POSTINC0
	movlw	"C"
	movwf	POSTINC0
	movlw	" "
	movwf	POSTINC0
	movlw	"M"
	movwf	POSTINC0
	movlw	"O"
	movwf	POSTINC0
	movlw	"N"
	movwf	POSTINC0
	movlw	"I"
	movwf	POSTINC0
	movlw	"T"
	movwf	POSTINC0
	movlw	"O"
	movwf	POSTINC0
	movlw	"R"
	movwf	POSTINC0
	movlw	CR
	movwf	POSTINC0
	movlw	LF
	movwf	POSTINC0
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
;
	clrf	loopy,1			;another 33 mS delay to settle down
lD1:	clrf	loopx,1
lD2:	nop
	decfsz	loopx,1
	goto	lD2
	decfsz	loopy,1
	goto	lD1
;
;The start of the program proper
;Make sure both clock and data are high
	clrf	loopz,1			;optional counter stops at 256 ack / naks
l1:	btfss	i2cprt,i2cclk,1		;must be high before start
	goto	l1			;keep waiting for high
	btfss	i2cprt,i2cdat,1		;must be high before start
	goto	l1			;keep waiting for high
;
;Clock and data high, wait for data to drop while clock remains high - Start
l2:	btfss	i2cprt,i2cclk,1		;must be high before start
	goto	l2			;loop if low
	btfsc	i2cprt,i2cdat,1		;must be low for start condition
	goto	l2			;loop if high
	btfss	i2cprt,i2cclk,1		;must still be high while data is low
	goto	l2			;loop if low
;
;Start condition satisfied
	movlw	'S'			;tell the world
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
;
;start condition, wait for clk to drop
l3:	btfsc	i2cprt,i2cclk,1		;clk is high, 
	goto	l3			;wait for clk low
;
;clk is low, data can change	
l4:	movlw	.2			;nibbles in byte
	movwf	loopx,1			;counter
l4a:	movlw	.4			;4 bits in nibble
	movwf	loopy,1			;counter
l5:	btfss	i2cprt,i2cclk,1		;wait for clk high
	goto	l5			;keep waiting
;
;clock is high, get data bit
	bcf	nib,7,1			;prepare for lo bit
	btfsc	i2cprt,i2cdat,1		;test data bit
	goto	hibit
;clock high, data low. Next STOP or data
;  if data rises before clock falls, STOP else data bit
la7a:	btfss	i2cprt,i2cclk,1		;must be high
	goto	hilobt			;clock has dropped, wait for next bit
	btfss	i2cprt,i2cdat,1		;must be high for STOP condition
	goto	la7a			;keep waiting for clock to drop or data to rise
;
;data has risen, is clock still high?
	btfsc	i2cprt,i2cclk,1		;test clock
	goto	stops			;hi so goto stop sequence
	goto	hilobt			;continue with low data
;
hibit:	bsf	nib,7,1			;prepare for hi bit
;
;clock high, data high. Next RESTART or data
;  if data falls before clock, RESTART else data bit
la7:	btfss	i2cprt,i2cclk,1		;must be high
	goto	hilobt			;clock has dropped, bit is high
	btfsc	i2cprt,i2cdat,1		;must be low for start condition
	goto	la7			;keep waiting for clock or data to drop
;
;data has dropped, is clock still high?
	btfsc	i2cprt,i2cclk,1		;test clock
	goto	rstart			;high so restart
;
;else fall thro' to deal with high data
hilobt:	rlncf	nib,F,1			;bit to lsb of nib
m1:	btfsc	i2cprt,i2cclk,		;wait for clock low
	goto	m1
	decfsz	loopy,F,1		;clock is low
	goto	l5			;nibble? no
;
;nibble complete, convert to ASCII
	movf	nib,W,1
	andlw	0x0F			;isolate low nibble
	addlw	.246			;>9 sets carry
	btfsc	STATUS,C,1		;test carry, no C < 0A
	addlw	.7			;was >9
	addlw	.58
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
	decfsz	loopx,F,1		;test for end of byte
	goto	l4a			;no, only end of nibble
;
;deal with ack / nack after 8 bits
l6:	btfss	i2cprt,i2cclk,1		;wait for clk high
	goto	l6			;keep waiting
;
;clock is high, get data bit
	movlw	"A"			;ready for Ack
	btfsc	i2cprt,i2cdat,1		;test data bit
	movlw	"N"			;no, it is Nack
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
l6a:	btfsc	i2cprt,i2cclk,1		;wait for clk low
	goto	l6a			;keep waiting
;
	if stop256 == true		;stop after 256 chars?
	decfsz	loopz,F,1		;this instruction not assembled if stop256 false
	endif
	goto	l4
	
stop1:	nop				;this is stop after 256 ack / naks
	goto	stop1			;needs reset to resume
;
;RESTART sequence 
rstart:	movlw	'R'			;tell the world
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
	goto	l3			;wait for data
;
;STOP sequence 
stops:	movlw	'P'			;tell the world
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1			;ensure buffer 000 to 7FF
	movlw	CR			;tell the world
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	movlw	LF			;tell the world
	movwf	POSTINC0		;into send buffer
	bcf	FSR0H,3,1		;ensure buffer 000 to 7FF
	clrf	INDF0			;null to signal end of data to send
	bsf	PIE1,TXIE,1		;Print to serial port
	goto	l1			;wait for start condition
;
	end